<?php
/**
 * Plugin Name: AI Student Verification
 * Plugin URI: https://bdsplugins.com/ai-student-verification
 * Description: Verify student IDs with AI and deliver preloaded discount coupons.
 * Version: 1.3
 * Author: BDS Plugins
 * Author URI: https://bdsplugins.com
 * Text Domain: ai-student-verification
 * Requires at least: 5.8
 * Tested up to: 6.6
 * Requires PHP: 7.4
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Prevent direct access
}

define( 'AISV_PATH', plugin_dir_path( __FILE__ ) );
define( 'AISV_URL', plugin_dir_url( __FILE__ ) );

// Load includes
require_once AISV_PATH . 'includes/class-aisv-settings.php';
require_once AISV_PATH . 'includes/class-aisv-hooks.php';
require_once AISV_PATH . 'includes/class-aisv-logs.php';
require_once AISV_PATH . 'includes/class-aisv-wpforms.php';
require_once AISV_PATH . 'includes/class-aisv-notices.php';
require_once AISV_PATH . 'includes/class-aisv-admin.php';
require_once AISV_PATH . 'includes/class-aisv-shortcode.php';

/**
 * Activation hook – create logs table
 */
register_activation_hook( __FILE__, 'aisv_create_logs_table' );

function aisv_create_logs_table() {
    global $wpdb;
    $table = $wpdb->prefix . 'aisv_logs';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        email varchar(200) NOT NULL,
        coupon varchar(100) NOT NULL,
        status varchar(20) NOT NULL,
        ai_reply text DEFAULT NULL,
        created_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta( $sql );

    if ( ! empty( $wpdb->last_error ) && defined( 'WP_DEBUG' ) && WP_DEBUG ) {
        error_log( 'AISV DB error: ' . $wpdb->last_error );
    }
}

/**
 * Enqueue admin CSS/JS for AISV
 */
add_action( 'admin_enqueue_scripts', function( $hook ) {
    // Only load on AISV pages or dashboard (index.php)
    if ( strpos( $hook, 'aisv' ) === false && $hook !== 'index.php' ) {
        return;
    }

    // Admin CSS
    wp_enqueue_style(
        'bds-aisv-admin',
        AISV_URL . 'assets/css/admin.css',
        [],
        '1.3'
    );

    // Inline JS for theme preview
    wp_add_inline_script(
        'jquery-core',
        "(function($){
            $(document).ready(function(){
                $('#aisv-form-theme').on('change', function(){
                    var val = $(this).val();
                    $('#aisv-theme-preview form')
                        .removeClass('aisv-form-card aisv-form-minimal aisv-form-inline aisv-form-glass aisv-form-dark')
                        .addClass('aisv-form-'+val);
                });
            });
        })(jQuery);"
    );
});

add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), function ( $links ) {
    $settings_link = '<a href="' . esc_url( admin_url( 'admin.php?page=aisv-settings' ) ) . '">' . esc_html__( 'Settings', 'ai-student-verification' ) . '</a>';
    $docs_link = '<a href="https://bdsplugins.com/documentation-ai-student-verification/" target="_blank" rel="noopener">' . esc_html__( 'Docs', 'ai-student-verification' ) . '</a>';
    array_unshift( $links, $settings_link, $docs_link );
    return $links;
});