jQuery(document).ready(function($) {
    $('#aisv-verification-form').on('submit', function(e) {
        e.preventDefault();
        var $form = $(this);
        var $msg  = $form.find('.aisv-form-message');

        var formData = new FormData(this);
        formData.append('action', 'aisv_submit_verification');
        formData.append('nonce', AISV_Form.nonce);

        $msg.html('<p style="color:#555;">Verifying…</p>');

        $.ajax({
            url: AISV_Form.ajax_url,
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function(res) {
                if (res.success) {
                    $msg.html('<p role="alert" style="color:green;">' + res.data.message + '</p>');
                } else {
                    $msg.html('<p role="alert" style="color:red;">' + (res.data && res.data.message ? res.data.message : 'Verification failed.') + '</p>');
                }
            },
            error: function() {
                $msg.html('<p role="alert" style="color:red;">Request failed. Please try again later.</p>');
            }
        });
    });
});
