<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class AISV_Logs {

    public static function render_logs_page() {
        $instance = new self();
        $instance->render_page();
    }

    public function render_page() {
        if ( ! current_user_can('manage_options') ) {
            wp_die( esc_html__( 'You do not have permission to view this page.', 'ai-student-verification' ) );
        }

        global $wpdb;
        $table = $wpdb->prefix . 'aisv_logs';

        // ---- Filters ----
        $email  = isset($_GET['email']) ? sanitize_text_field($_GET['email']) : '';
        $allowed_statuses = ['approved','declined','error','duplicate'];
        $status = (isset($_GET['status']) && in_array($_GET['status'], $allowed_statuses, true)) ? $_GET['status'] : '';
        $from   = isset($_GET['from']) ? sanitize_text_field($_GET['from']) : '';
        $to     = isset($_GET['to'])   ? sanitize_text_field($_GET['to'])   : '';

        $where = 'WHERE 1=1';
        $args  = [];

        if ($email !== '') {
            $where .= ' AND email LIKE %s';
            $args[] = '%' . $wpdb->esc_like($email) . '%';
        }
        if ($status !== '') {
            $where .= ' AND status = %s';
            $args[] = $status;
        }
        if ($from !== '') {
            $where .= ' AND created_at >= %s';
            $args[] = $from . ' 00:00:00';
        }
        if ($to !== '') {
            $where .= ' AND created_at <= %s';
            $args[] = $to . ' 23:59:59';
        }

        // ---- Pagination ----
        $pp    = 25;
        $paged = max(1, (int)($_GET['paged'] ?? 1));
        $off   = ($paged - 1) * $pp;

        $total = (int) $wpdb->get_var( $wpdb->prepare("SELECT COUNT(*) FROM $table $where", ...$args) );
        $rows  = $wpdb->get_results(
            $wpdb->prepare("SELECT * FROM $table $where ORDER BY id DESC LIMIT %d OFFSET %d", ...array_merge($args, [$pp, $off])),
            ARRAY_A
        );

        echo '<div class="wrap"><h1>' . esc_html__( 'AI Student Verification Logs', 'ai-student-verification' ) . '</h1>';

        // Filter form
        echo '<form method="get" class="aisv-logs-form">';
        echo '<input type="hidden" name="page" value="aisv-logs">';
        echo '<input type="text" name="email" placeholder="' . esc_attr__( 'Filter by email', 'ai-student-verification' ) . '" value="'.esc_attr($email).'" /> ';
        echo '<select name="status">
                <option value="">' . esc_html__( 'All statuses', 'ai-student-verification' ) . '</option>
                <option value="approved" '.selected($status,'approved',false).'>' . esc_html__( 'Approved', 'ai-student-verification' ) . '</option>
                <option value="declined" '.selected($status,'declined',false).'>' . esc_html__( 'Declined', 'ai-student-verification' ) . '</option>
                <option value="error" '.selected($status,'error',false).'>' . esc_html__( 'Error', 'ai-student-verification' ) . '</option>
                <option value="duplicate" '.selected($status,'duplicate',false).'>' . esc_html__( 'Duplicate', 'ai-student-verification' ) . '</option>
              </select> ';
        echo esc_html__( 'From', 'ai-student-verification' ) . ' <input type="date" name="from" value="'.esc_attr($from).'"> ';
        echo esc_html__( 'To', 'ai-student-verification' ) . ' <input type="date" name="to" value="'.esc_attr($to).'"> ';
        echo ' <button class="button">' . esc_html__( 'Filter', 'ai-student-verification' ) . '</button>';
        echo '</form>';

        // Clear filters link
        $clear_url = admin_url( 'admin.php?page=aisv-logs' );
        echo ' <a href="'.esc_url($clear_url).'" class="aisv-logs-clear">' . esc_html__( 'Clear', 'ai-student-verification' ) . '</a>';

        // Table
        echo '<table class="widefat striped aisv-logs-table"><thead><tr>
                <th>' . esc_html__( 'ID', 'ai-student-verification' ) . '</th>
                <th>' . esc_html__( 'Email', 'ai-student-verification' ) . '</th>
                <th>' . esc_html__( 'Coupon', 'ai-student-verification' ) . '</th>
                <th>' . esc_html__( 'Status', 'ai-student-verification' ) . '</th>
                <th style="width:40%;">' . esc_html__( 'AI Reply', 'ai-student-verification' ) . '</th>
                <th>' . esc_html__( 'Date', 'ai-student-verification' ) . '</th>
              </tr></thead><tbody>';

        if (empty($rows)) {
            echo '<tr><td colspan="6">' . esc_html__( 'No logs found.', 'ai-student-verification' ) . '</td></tr>';
        } else {
            foreach ($rows as $r) {
                echo '<tr>
                        <td>'.(int)$r['id'].'</td>
                        <td>'.esc_html($r['email']).'</td>
                        <td>'.esc_html($r['coupon']).'</td>
                        <td>'.esc_html($r['status']).'</td>
                        <td>'.esc_html( wp_trim_words($r['ai_reply'] ?? '', 25, '…') ).'</td>
                        <td>'.esc_html($r['created_at']).'</td>
                      </tr>';
            }
        }
        echo '</tbody></table>';

        // Pagination links
        $pages = max(1, (int)ceil($total / $pp));
        if ($pages > 1) {
            echo '<p class="aisv-logs-pagination">';
            $safe_get = array_map('sanitize_text_field', $_GET);
            for ($i = 1; $i <= $pages; $i++) {
                $url = esc_url( add_query_arg( array_merge($safe_get, ['paged'=>$i]) ) );
                echo $i === $paged ? "<strong>$i</strong> " : "<a href='$url'>$i</a> ";
            }
            echo '</p>';
        }

        echo '</div>';
    }
}
