<?php
if ( ! defined('ABSPATH') ) exit;

class AISV_Notices {
    public function __construct() {
        add_action('admin_notices', [ $this, 'render_notices' ]);
        add_action('admin_post_aisv_clear_error', [ $this, 'clear_error' ]);
    }

    public function render_notices() {
        if ( ! current_user_can('manage_options') ) {
            return;
        }

        // Missing license
        if ( ! get_option('aisv_license_key') ) {
            $this->notice(
                __( 'Please enter your <strong>AISV License Key</strong> to enable student verification.', 'ai-student-verification' ),
                'error'
            );
        }

        // Coupons
        $list  = (string) get_option('aisv_coupon_list','');
        $count = 0;
        if ( $list !== '' ) {
            $coupons = array_values(array_filter(array_map('trim', preg_split("/\r\n|\n|\r/", $list))));
            $count   = count($coupons);
        }

        if ( $count === 0 ) {
            $this->notice(
                __( 'Your <strong>coupon list is empty</strong>. Approved verifications will not receive a code.', 'ai-student-verification' ),
                'error'
            );
        } elseif ( $count <= 3 ) {
            $this->notice(
                sprintf(
                    _n( 
                        'Only <strong>%s coupon</strong> left. Consider adding more.', 
                        'Only <strong>%s coupons</strong> left. Consider adding more.', 
                        $count, 
                        'ai-student-verification' 
                    ),
                    $count
                ),
                'warning'
            );
        }

        // Last API error
        $err = get_option('aisv_last_error','');
        if ( $err ) {
            $url = wp_nonce_url( admin_url('admin-post.php?action=aisv_clear_error'), 'aisv_clear_error' );
            $this->notice(
                sprintf(
                    /* translators: %s: error message */
                    __( 'AI Student Verification error: %s &nbsp; <a href="%s">Clear</a>', 'ai-student-verification' ),
                    esc_html($err),
                    esc_url($url)
                ),
                'error'
            );
        }
    }

    public function clear_error() {
        if ( ! current_user_can('manage_options') ) {
            wp_die( esc_html__( 'You do not have permission to perform this action.', 'ai-student-verification' ) );
        }
        check_admin_referer('aisv_clear_error');
        delete_option('aisv_last_error');
        wp_safe_redirect( wp_get_referer() ? wp_get_referer() : admin_url() );
        exit;
    }

    private function notice( $msg, $type = 'info' ) {
        printf(
            '<div class="notice notice-%s is-dismissible"><p>%s</p></div>',
            esc_attr($type),
            wp_kses_post($msg)
        );
    }
}
new AISV_Notices();
