<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class AISV_Settings {

    public function __construct() {
        add_action( 'admin_init', [ $this, 'register_settings' ] );
    }

    public function register_settings() {
        // Core settings
        register_setting('aisv_settings_group_core', 'aisv_license_key', [
            'sanitize_callback' => 'sanitize_text_field',
        ]);
        register_setting('aisv_settings_group_core', 'aisv_verification_mode', [
            'sanitize_callback' => 'sanitize_text_field',
        ]);
        register_setting('aisv_settings_group_core', 'aisv_coupon_list', [
            'sanitize_callback' => 'sanitize_textarea_field',
        ]);
        register_setting('aisv_settings_group_core', 'aisv_reapply_limit_days', [
            'sanitize_callback' => 'absint',
        ]);
        register_setting('aisv_settings_group_core', 'aisv_form_theme', [
            'sanitize_callback' => 'sanitize_text_field',
        ]);
        register_setting('aisv_settings_group_core', 'aisv_send_admin_copy', [
            'sanitize_callback' => 'absint',
        ]);

        // Email settings
        register_setting('aisv_settings_group_emails', 'aisv_email_subject_success', [
            'sanitize_callback' => 'sanitize_text_field',
        ]);
        register_setting('aisv_settings_group_emails', 'aisv_email_success_template', [
            'sanitize_callback' => [ $this, 'sanitize_email_template' ],
        ]);

        register_setting('aisv_settings_group_emails', 'aisv_email_subject_failure', [
            'sanitize_callback' => 'sanitize_text_field',
        ]);
        register_setting('aisv_settings_group_emails', 'aisv_email_failure_template', [
            'sanitize_callback' => [ $this, 'sanitize_email_template' ],
        ]);

        register_setting('aisv_settings_group_emails', 'aisv_email_subject_duplicate', [
            'sanitize_callback' => 'sanitize_text_field',
        ]);
        register_setting('aisv_settings_group_emails', 'aisv_email_duplicate_template', [
            'sanitize_callback' => [ $this, 'sanitize_email_template' ],
        ]);
    }

    /**
     * Allow safe HTML for email templates.
     */
    public function sanitize_email_template( $content ) {
        return wp_kses_post( $content );
    }
}
new AISV_Settings();
