<?php
if ( ! defined('ABSPATH') ) exit;

class AISV_Shortcode {

    public function __construct() {
        add_shortcode( 'aisv_verification_form', [ $this, 'render_form' ] );
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_assets' ] );
        add_action( 'wp_ajax_aisv_submit_verification', [ $this, 'handle_submission' ] );
        add_action( 'wp_ajax_nopriv_aisv_submit_verification', [ $this, 'handle_submission' ] );
    }

    public function enqueue_assets() {
        wp_enqueue_style(
            'aisv-shortcode',
            AISV_URL . 'assets/css/shortcode.css',
            [],
            '1.1'
        );
        wp_enqueue_script(
            'aisv-shortcode',
            AISV_URL . 'assets/js/shortcode.js',
            ['jquery'],
            '1.1',
            true
        );
        wp_localize_script('aisv-shortcode', 'AISV_Form', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('aisv_verify_nonce')
        ]);
    }

    public function render_form( $atts ) {
        $atts = shortcode_atts([
            'theme' => get_option('aisv_form_theme','card'),
        ], $atts, 'aisv_verification_form');

        $theme_class = 'aisv-form-' . sanitize_html_class($atts['theme']);

        ob_start(); ?>
        <form id="aisv-verification-form"
              class="aisv-form <?php echo esc_attr($theme_class); ?>"
              enctype="multipart/form-data">
            
            <div class="aisv-field">
                <label for="aisv-email"><?php esc_html_e( 'Email', 'ai-student-verification' ); ?></label>
                <input type="email" id="aisv-email" name="aisv_email" required>
            </div>

            <div class="aisv-field">
                <label for="aisv-id"><?php esc_html_e( 'Upload Student ID', 'ai-student-verification' ); ?></label>
                <input type="file" id="aisv-id" name="aisv_id" accept="image/*,application/pdf" required>
            </div>
            
            <button type="submit" class="aisv-btn"><?php esc_html_e( 'Verify', 'ai-student-verification' ); ?></button>
            <div class="aisv-form-message" role="alert" aria-live="polite"></div>
        </form>
        <?php
        return ob_get_clean();
    }

	public function handle_submission() {
		check_ajax_referer('aisv_verify_nonce', 'nonce');

		$email = sanitize_email($_POST['aisv_email'] ?? '');
		$file  = $_FILES['aisv_id'] ?? null;

		if ( ! $email || empty($file['tmp_name']) ) {
			wp_send_json_error([
				'status'  => 'error',
				'message' => __( 'Email and ID upload are required.', 'ai-student-verification' )
			]);
		}

		// ✅ Pass both tmp_name and original name to verification
		$file_data = [
			'tmp_name' => $file['tmp_name'],
			'name'     => $file['name'] ?? '',
		];

		$result = AISV_Hooks::process_verification($email, $file_data);

		if ($result['status'] === 'approved') {
			wp_send_json_success([
				'status'  => 'approved',
				'message' => __( 'Verification successful. Please check your email for the coupon.', 'ai-student-verification' )
			]);
		} else {
			wp_send_json_error([
				'status'  => $result['status'],
				'message' => __( $result['message'], 'ai-student-verification' )
			]);
		}
	}

}
new AISV_Shortcode();
