<?php
/**
 * Uninstall cleanup for AI Student Verification
 */
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

function aisv_delete_site_data() {
	global $wpdb;

	// Options to remove
	$options = [
		'aisv_license_key',
		'aisv_verification_mode',
		'aisv_coupon_list',
		'aisv_reapply_limit_days',
		'aisv_form_theme',
		'aisv_send_admin_copy',
		'aisv_last_error',
	];

	foreach ( $options as $opt ) {
		delete_option( $opt );
	}

	// Transients / locks
	delete_transient( 'aisv_coupon_lock' );

	// Drop logs table
	$table = $wpdb->prefix . 'aisv_logs';
	$wpdb->query( "DROP TABLE IF EXISTS `{$table}`" ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
}

// If network uninstall, loop sites. Otherwise, just current site.
if ( is_multisite() ) {
	$site_ids = get_sites( [ 'fields' => 'ids' ] );
	foreach ( $site_ids as $site_id ) {
		switch_to_blog( $site_id );
		aisv_delete_site_data();
		restore_current_blog();
	}
} else {
	aisv_delete_site_data();
}
